<?php $__env->startSection('content'); ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">Checkout</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Licenses</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <?php echo $__env->make('notify.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('notify.success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="container-fluid">
                <div class="row">
                    <!-- left column -->
                    <div class="col-md-6">
                        <!-- general form elements -->
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Order License</h3>
                            </div>
                            <!-- /.card-header -->
                            <!-- form start -->
                            <form role="form" method="post" action="<?php echo e(route('license.add')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label>Select Software:</label>
                                        <select onchange="makeLicenseKey(this)" class="form-control" name="software_id"
                                            id="software-select">
                                            <?php if($softwares): ?>
                                                <option selected>Select Software</option>
                                                <?php $__currentLoopData = $softwares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $software): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option key-name="<?php echo e($software->name); ?>" value="<?php echo e($software->id); ?>">
                                                        <?php echo e($software->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>


                                    <!--<div class="form-group">-->
                                    <!--    <label for="name">License key</label>-->
                                    <!--    <input type="text" class="form-control" value="<?php echo e(old('license_key')); ?>"-->
                                    <!--        name="license_key" id="license_key" placeholder="">-->
                                    <!--</div>-->

                                    <div id="div-content" class="d-none">
                                        <!-- End at select -->
                                        <div class="form-group">
                                            <label>Buy for:</label>
                                            <select class="form-control" name="end_at" id="show_month">

                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="name">IPv4</label>
                                            <input type="text" class="form-control" value="<?php echo e(old('ip')); ?>"
                                                name="ip" id="ip" placeholder="">
                                        </div>
                                    </div>
                                    <!-- select -->

                                    <!-- Software select -->


                                    <!-- select -->
                                    <?php
                                        $reseller_id = App\Models\Reseller::firstWhere('user_id', Auth::id());
                                    ?>
                                    <div class="form-group" style="display:none">
                                        <label>Reseller</label>
                                        <select class="form-control" name="reseller">
                                            <option value="<?php echo e($reseller_id->id); ?>"
                                                <?php echo e($reseller_id->reseller_id == $reseller_id->id ? 'selected' : ''); ?>>
                                                <?php echo e($reseller_id->name); ?></option>
                                        </select>
                                    </div>
                                    <!-- select -->
                                </div>
                                <!-- /.card-body -->

                                <div class="card-footer text-right">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>

            </div>

            <!-- /.card -->
    </div><!-- /.container-fluid -->
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function() {
            $('#software-select').change(function() {
                var softwareId = $(this).val();
                $.ajax({
                    url: "/panel/product/price/" + softwareId,
                    success: function(data) {
                        $('#show_month').html(data);
                    }
                });
            });
        });
    </script>

    <script>
        const makeLicenseKey = key => {
            console.dir(key.attributes);
            $('#div-content').removeClass('d-none');
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/SysLic/public_html/admin/application/resources/views/licenses/add.blade.php ENDPATH**/ ?>